# saturate_134M.py
# Generate BTC covenant script for 134M+ unique vectors using HDGL folding

SEED_VECTORS = 2               # Starting vectors
FOLD_STEPS = 28                # 2^28 ≈ 268M vectors (covers 134M easily)
SEED_PARAMS = ["0x812", "0x502", "0x310", "0x192"]  # Example seed parameters
FIBS = [1,1,2,3,5,8,13,21,34,55,89]                  # Fibonacci deltas

CTv_PUBKEY = "<YOUR_PUBLIC_KEY>"  # Replace with your actual public key

script = [f"{CTv_PUBKEY} OP_CHECKSIGVERIFY"]

vector_count = SEED_VECTORS
fib_index = 0

for step in range(FOLD_STEPS):
    prev_count = vector_count
    vector_count *= 2  # exponential fold

    # Fold vectors
    script.append(f"OP_VEC_DUP {prev_count} OP_HDGL_VEC_ADD OP_EQUALVERIFY")
    
    # Param addition
    script.append(f"{prev_count} {prev_count} OP_HDGL_PARAM_ADD OP_EQUALVERIFY")
    
    # Fibonacci delta for uniqueness
    param = SEED_PARAMS[step % len(SEED_PARAMS)]
    omega_int = int(param, 16)
    fib_delta = FIBS[fib_index % len(FIBS)]
    fib_index += 1
    omega_min = omega_int + fib_delta
    omega_max = omega_int + fib_delta
    script.append(f"{omega_int} {omega_min} {omega_max} OP_WITHINVERIFY")
    script.append("")  # blank line for readability

# Finalize covenant
script.append("OP_CHECKTEMPLATEVERIFY")

# Output full covenant script
full_script = "\n".join(script)
with open("hdgl_134M.vec", "w") as f:
    f.write(full_script)

print(f"=== Generated HDGL Covenant Script for {vector_count} vectors ===")
print(full_script)
